IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Productos_DEUDA]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CP_Productos_DEUDA
END
GO

CREATE PROCEDURE [dbo].[CP_Productos_DEUDA](
     @pUsuario    INT
   , @pFlag_Excluye_Pagos_A_Cuenta TINYINT			--05/08/2019 Se agrega por Ticket 17.489
   , @pEquate  SMALLINT
   , @pEquateClientes SMALLINT
   , @FECHA DATETIME
   )
AS
  --CREATE TABLE #Trans (Id_Trans INT)
 

  DECLARE @DEUDA table (Id_Trans INT,coef decimal(12,5) )
  DECLARE @PagosACta table (Id_Trans INT,coef decimal(12,5) )

  PRINT '[CP_Productos_DEUDA]'

  IF @pEquate = 0
     RETURN

  DECLARE @Id_Producto Varchar(14)
		  ,@Id_Proveedor Int
		  ,@Razon_Social VarChar(100)
		  ,@Cuit Varchar(13)
		  ,@Id_Iva Char(3)
		  ,@Id_Alias_Cta_Cont Int
		  ,@Id_Cta_Contable_H Int
		  ,@Porc_Comision_Prov Decimal(7,2) 
		  ,@Importe Decimal(12,2) 
		  ,@IMPORTE_CREDITO Decimal(12,2) 
		  ,@ID_TIPO_CBTE CHAR(4) 
		  ,@Imp_prod_siva  Decimal(12,2) 
		  ,@TRANS INT
		  ,@Id_Cliente_Externo VARCHAR(14)
		  ,@Id_Cta_Banco INT
		  ,@Id_Cliente INT
		  ,@EXISTE_TAG INT

  SET @EXISTE_TAG = 0
  SET @EXISTE_TAG = (SELECT COUNT(*) FROM TagFile_ TAG WHERE TAG.TBL = @pEquateClientes AND TAG.USR = @pUsuario)

 
  SELECT ID_TRANS, 
  ISNULL((SELECT C.Imp_Total - (SUM(Importe) * CT.Compromete_Factura) 
  		FROM Cbtes_Aplica A, Cbtes D
  		WHERE A.Id_Trans = C.Id_Trans and A.Id_Trans_D = D.Id_Trans and D.Id_Estado_Cbte NOT IN (0,3)),C.Imp_Total) AS SALDO 
  INTO #SALDOS
  FROM Cbtes C, Cbtes_Tipos CT
  WHERE C.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
  AND CT.Compromete_Factura IN (1,-1)
  AND C.Id_Estado_Cbte NOT IN (0,3)
  AND C.Id_Cond_Pago <> 1
  AND C.Imp_Total <> 0
  AND C.FECHA < DATEADD(DAY,1,@FECHA)

  /*Deuda*/
  PRINT 'Deuda'
  IF @EXISTE_TAG > 0
     BEGIN
	 PRINT '>0'
	 INSERT INTO @DEUDA
		SELECT c.id_trans, S.SALDO/c.imp_total as coef
			 FROM cbtes c, cbtes_tipos t, TagFile_ TAG, #SALDOS S 
 			 WHERE c.id_tipo_cbte = t.id_tipo_cbte
					 and c.Id_Trans = S.Id_Trans
			         and t.Compromete_Factura in (1,-1)
					 and c.id_estado_cbte NOT IN (0,3) 
					 and S.SALDO <> 0
					 and isnull(c.imp_total,0) <> 0
					 and ISNULL(c.id_cond_pago,0) <> 1
					 AND (C.id_cliente = TAG.Ptr AND TAG.TBL = @pEquateClientes AND TAG.USR = @pUsuario)
     END
  ELSE
     BEGIN
		PRINT '<=0'
	    INSERT INTO @deuda
		SELECT c.id_trans, S.SALDO/c.imp_total as coef
			 FROM cbtes c, cbtes_tipos t,Clientes e, #SALDOS S
 			 WHERE c.id_tipo_cbte = t.id_tipo_cbte 	 
				     and c.Id_Trans = S.Id_Trans
					 and t.Compromete_Factura in (1,-1)
			 		 and isnull(c.imp_total,0) <> 0
			 		 and e.id_cliente = c.id_cliente
			 		 and e.activo = 1
					 and ISNULL(c.id_cond_pago,0) <> 1
					 and c.id_estado_cbte NOT IN (0,3) and S.SALDO <> 0
 	 
      END

	IF(@pFlag_Excluye_Pagos_A_Cuenta = 0)
	BEGIN

		SELECT CB.Id_Trans, (SELECT cb.Imp_Total -
							   (
								(SELECT DISTINCT ISNULL(SUM(IMPORTE),0) * -1
										FROM Cbtes_Aplica A, Cbtes C
										WHERE A.Id_Trans = CB.Id_Trans
												AND A.Id_Trans_D = C.Id_Trans
												AND C.Id_Estado_Cbte NOT IN (0,3)) 
								+
								(SELECT DISTINCT ISNULL(SUM(IMPORTE),0)
										FROM Cbtes_Aplica A, Cbtes C
										WHERE A.Id_Trans_D = CB.Id_Trans
											  AND A.Id_Trans = C.Id_Trans
											  AND C.Id_Estado_Cbte  NOT IN (0,3) 
											  AND A.Id_Trans <> 0) 
							    )
						    ) AS Saldo
		INTO #Saldos_PagoACuenta
		FROM Cbtes CB, Cbtes_Tipos CT
		WHERE 
		CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte 
		AND CT.Compromete_Recibos = 1
		AND CB.Id_Estado_Cbte NOT IN (0,3)
		AND ISNULL(CB.Imp_Total, 0) <> 0
		AND ISNULL(CB.Id_Cond_Pago, 0) <> 1
		AND CB.FECHA < DATEADD(DAY,1,@FECHA)

		/*NO Excluye los pagos a Cuenta*/
		/*Pagos*/
		PRINT 'Pagos a Cuenta'
		IF @EXISTE_TAG > 0
		BEGIN
			PRINT 'Pagos a Cuenta (con Tag)'
			INSERT INTO @PagosACta
			SELECT CB.Id_Trans, S.Saldo/CB.Imp_Total AS coef
				FROM Cbtes CB, Cbtes_Tipos CT, TagFile_ TAG, #Saldos_PagoACuenta S
				WHERE 
				CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte 
				AND CB.Id_Trans = S.Id_Trans
				AND CT.Compromete_Recibos = 1
				AND CB.Id_Estado_Cbte NOT IN (0,3) 
				AND S.Saldo <> 0
				AND ISNULL(CB.Imp_Total, 0) <> 0
				AND ISNULL(CB.Id_Cond_Pago, 0) <> 1
				AND (CB.Id_Cliente = TAG.Ptr AND TAG.TBL = @pEquateClientes AND TAG.USR = @pUsuario)
		END
		ELSE
		BEGIN
			PRINT 'Pagos a Cuenta (sin Tag)'
			INSERT INTO @PagosACta
			SELECT CB.Id_Trans, S.Saldo/CB.Imp_Total AS coef
				FROM Cbtes CB, Cbtes_Tipos CT, Clientes CL, #Saldos_PagoACuenta S
 				WHERE 
 				CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte 
				AND CB.Id_Trans = S.Id_Trans
 				AND CT.Compromete_Recibos = 1
 				AND CB.Id_Estado_Cbte NOT IN (0,3) 
 				AND S.Saldo <> 0
				AND ISNULL(CB.Imp_Total,0) <> 0
				AND ISNULL(CB.Id_Cond_Pago,0) <> 1
				AND CL.Id_Cliente = CB.Id_Cliente
				AND CL.Activo = 1
		END
	END
	
/*----------------------------------------------------------------------------*/
  SET @EXISTE_TAG = 0
  SET @EXISTE_TAG = (SELECT COUNT(*) FROM TagFilePos_ TAG WHERE TAG.TBL = @pEquate AND TAG.USR = @pUsuario)

  IF @EXISTE_TAG > 0             /* Tag Productos*/
      BEGIN 
	  PRINT 'C'
        SELECT f.id_trans,f.Fecha,c.id_cliente,c.Razon_Social,c.id_cliente_externo,
                     i.id_producto,p.descripcion_detallada,i.fecha_qa as mes,
                     i.imp_final,(i.imp_final * tr.compromete_factura)*(1-(isnull(f.Porc_Bonificacion,0)/100)) as Bonificacion ,
                     f.Porc_Bonificacion,
                     (i.imp_final * tr.compromete_factura)*(1-(isnull(f.Porc_Bonificacion,0)/100)) * (1-( isnull(f.Porc_DescEspecial,0)/100)) as DescEspecial , 
                     f.Porc_DescEspecial,
					 (S.SALDO * tr.compromete_factura) / f.Imp_Total *  i.imp_final       AS Saldo,
                     i.fecha_venc,Flag_Periodo,Flag_Mes,d.coef,I.ITEM,dbo.CF_Cbte_Descrip(F.Id_Trans) AS CBTE_DESCRIP,
					 c.Id_Tipo_Cli,
					 CT.Descripcion,
					 P.Id_Alias_Cta_Cont
				  INTO #DeudaRpt1
				  FROM cbtes_items i, cbtes F, @DEUDA D, TagFilePos_ Tag , Cbtes_tipos TR, CLIENTES C, PRODUCTOS P, Clientes_Tipos CT, #SALDOS S
				  WHERE F.ID_TRANS = I.ID_TRANS 
				  AND F.ID_TRANS = D.ID_TRANS 
				  AND F.Id_Trans = S.Id_Trans
				  AND TR.ID_TIPO_CBTE = F.ID_TIPO_CBTE
				  AND C.ID_CLIENTE = F.ID_CLIENTE
				  AND P.ID_PRODUCTO = I.ID_PRODUCTO
				  AND CT.Id_Tipo_Cli = C.Id_Tipo_Cli
				  AND I.imp_final <> 0
				  AND (i.id_producto = TAG.POS AND TAG.TBL = @pEquate AND TAG.USR = @pUsuario)

 
           SELECT D.*,O.Nro_Cta_Contable,O.Descripcion as Descrip_Cta_Contable,0 AS Id_Cliente_Ref, CONVERT(VARCHAR(100),'') AS Razon_Social_Ref, CONVERT(VARCHAR(14),'') AS Id_Cliente_Externo_Ref  
				INTO #Resultado1
				FROM #DeudaRpt1 D LEFT OUTER JOIN Pla_Ctas_Cuentas_Contables O ON O.Id_Cta_Contable = dbo.CF_Cta_Cont( D.Id_Alias_Cta_Cont,D.Fecha)

		/* Pagos a ACta: Es lo mismo que el anterio*/
		IF(@pFlag_Excluye_Pagos_A_Cuenta = 0)
		BEGIN
			/*NO Excluye los pagos a Cuenta*/
			INSERT INTO #Resultado1
			SELECT 
			CB.Id_Trans,
			CB.Fecha,
			CL.Id_Cliente,
			CL.Razon_Social,
			CL.Id_Cliente_Externo,
			'P/C' AS Id_Producto,
			'z-Pago a Cta' AS Descripcion_Detallada,
			CB.fecha AS Mes,
			CB.Imp_Total *-1 AS Imp_Final,
			0 AS Bonificacion,
			CB.Porc_Bonificacion,
			0 AS DescEspecial,
			CB.Porc_DescEspecial,
			--CB.Saldo *-1 AS Saldo,
			S.Saldo * -1 AS Saldo,
			CB.Fecha as Fecha_Venc,
			0 AS Flag_Periodo,
			0 AS Flag_Mes,
			d.Coef,
			1 AS Item,
			dbo.CF_Cbte_Descrip(CB.Id_Trans) AS Cbte_Descrip,
			CL.Id_Tipo_Cli,
			CT.Descripcion,
			0 AS Id_Alias_Cta_Cont,
			'' AS Nro_Cta_Contable,
			'' AS Descrip_Cta_Contable,
			isnull(CL.Id_Cliente_Ref,0),
			'' AS Razon_Social_Ref,
			'' AS Id_Cliente_Externo_Ref
			FROM Cbtes CB, @PagosACta D, Cbtes_Tipos CBT, Clientes CL, Clientes_Tipos CT, #Saldos_PagoACuenta S
			WHERE 
			CB.Id_Trans = D.Id_Trans
			AND CB.Id_Trans = S.Id_Trans
			AND CBT.Id_Tipo_Cbte = CB.Id_Tipo_Cbte
			AND CL.Id_Cliente = CB.Id_Cliente
			AND CT.Id_Tipo_Cli = CL.Id_Tipo_Cli
			AND CB.Imp_Total <> 0
		 END

         Alter table #Resultado1 add Fecha_utl_Pago DATETIME

		 UPDATE #Resultado1 SET Id_Cliente_Ref = isnull(CL.id_cliente_ref,0) FROM #Resultado1 R, Clientes CL WHERE R.Id_Cliente = CL.Id_Cliente
		 UPDATE #Resultado1 SET Razon_Social_Ref = CL.Razon_Social , Id_Cliente_Externo_Ref = isnull(CL.Id_Cliente_Externo,'')FROM #Resultado1 R, Clientes CL WHERE R.Id_Cliente_Ref = CL.Id_Cliente
	     UPDATE #Resultado1 SET Razon_Social_Ref= '' WHERE ISNULL(id_cliente_ref,0)=0

		 Select c.id_cliente,i.id_producto,max(i.fecha_qa) as Fecha_utl_Pago 
		       Into #UltPago 
		       From cbtes c, cbtes_items i, #Resultado1 R
			   Where i.id_trans = c.id_trans and c.id_estado_cbte in (2,4)
			         and i.Id_Cliente = R.Id_Cliente
			         and i.id_producto = R.id_Producto
			   Group by c.id_cliente,i.id_producto

        

         UPDATE #Resultado1 SET Fecha_utl_Pago = U.Fecha_utl_Pago 
		 From #Resultado1 R, #UltPago u
		 WHERE 	u.Id_Cliente = R.Id_Cliente  and u.id_producto = R.id_Producto

		 SELECT * FROM #Resultado1 ORDER BY Razon_Social_Ref,Razon_Social,descripcion_detallada,mes


       END
      ELSE
       BEGIN 
			PRINT 'D'
			SELECT f.id_trans,f.Fecha,c.id_cliente,c.Razon_Social,c.id_cliente_externo,
						 i.id_producto,p.descripcion_detallada,i.fecha_qa as mes,
						 i.imp_final,(i.imp_final * tr.compromete_factura)*(1-(isnull(f.Porc_Bonificacion,0)/100)) as Bonificacion ,
						 f.Porc_Bonificacion,
						 (i.imp_final * tr.compromete_factura)*(1-(isnull(f.Porc_Bonificacion,0)/100)) * (1-( isnull(f.Porc_DescEspecial,0)/100)) as DescEspecial , 
						 f.Porc_DescEspecial,
						 --(i.imp_final * tr.compromete_factura)*(1-(isnull(f.Porc_Bonificacion,0)/100)) * (1-( isnull(f.Porc_DescEspecial,0)/100)) * (d.coef) as Saldo, 
					     (S.SALDO * tr.compromete_factura) / f.Imp_Total *  i.imp_final       AS Saldo,
						 i.fecha_venc,Flag_Periodo,Flag_Mes,d.coef,I.Item,dbo.CF_Cbte_Descrip(F.Id_Trans) AS Cbte_Descrip,
						 c.Id_Tipo_Cli,
						 CT.Descripcion,
						 P.Id_Alias_Cta_Cont
					  INTO #DeudaRpt2
					  FROM cbtes_items i, cbtes F, @DEUDA D, Cbtes_tipos TR, CLIENTES C, PRODUCTOS P, Clientes_Tipos CT, #SALDOS S
					  WHERE F.ID_TRANS = I.ID_TRANS
					  AND F.ID_TRANS = D.ID_TRANS 
					  AND F.Id_Trans = S.Id_Trans
					  AND TR.ID_TIPO_CBTE = F.ID_TIPO_CBTE
					  AND C.ID_CLIENTE = F.ID_CLIENTE
					  AND P.ID_PRODUCTO = I.ID_PRODUCTO
					  AND CT.Id_Tipo_Cli = C.Id_Tipo_Cli
					  AND I.imp_final <> 0

			 SELECT D.*,O.Nro_Cta_Contable,O.Descripcion as Descrip_Cta_Contable , 0 AS Id_Cliente_Ref,  CONVERT(VARCHAR(100),'') AS Razon_Social_Ref, CONVERT(VARCHAR(14),'') AS Id_Cliente_Externo_Ref  
				INTO #Resultado2
				FROM #DeudaRpt2 D LEFT OUTER JOIN Pla_Ctas_Cuentas_Contables O ON O.Id_Cta_Contable = dbo.CF_Cta_Cont( D.Id_Alias_Cta_Cont,D.Fecha)

			/* Pagos a ACta: Es lo mismo que el anterio*/
			IF(@pFlag_Excluye_Pagos_A_Cuenta = 0)
			BEGIN
				/*NO Excluye los pagos a Cuenta*/
				INSERT INTO #Resultado2
				SELECT 
				CB.Id_Trans,
				CB.Fecha,
				CL.Id_Cliente,
				CL.Razon_Social,
				CL.Id_Cliente_Externo,
				'P/C' AS Id_Producto,
				'z-Pago a Cta' AS Descripcion_Detallada,
				CB.Fecha AS Mes,
				CB.Imp_Total *-1 AS Imp_Final,
				0 AS Bonificacion,
				CB.Porc_Bonificacion,
				0 AS DescEspecial,
				CB.Porc_DescEspecial,
				--CB.saldo AS saldo, 
				S.Saldo *-1 AS Saldo,
				CB.Fecha as Fecha_Venc,
				0 AS Flag_Periodo,
				0 as Flag_Mes,
				D.Coef,
				1 AS Item,
				dbo.CF_Cbte_Descrip(CB.Id_Trans) AS Cbte_Descrip,
				CL.Id_Tipo_Cli,
				CT.Descripcion,
				0 AS Id_Alias_Cta_Cont,
				'' AS Nro_Cta_Contable,
				'' AS Descrip_Cta_Contable,
				CL.Id_Cliente_Ref,
				'' AS Razon_Social_Ref,
				'' AS Id_Cliente_Externo_Ref
				FROM Cbtes CB, @PagosACta D , Cbtes_Tipos TR, Clientes CL, Clientes_Tipos CT, #Saldos_PagoACuenta S
				WHERE 
				CB.Id_Trans = D.Id_Trans
				AND CB.Id_Trans = S.Id_Trans
				AND TR.Id_Tipo_Cbte = CB.Id_Tipo_Cbte
				AND CL.Id_Cliente = CB.Id_Cliente
				AND CT.Id_Tipo_Cli = CL.Id_Tipo_Cli
				AND CB.Imp_Total <> 0
			END
         Alter table #Resultado2 add Fecha_utl_Pago DATETIME    --27/12/22 Se cambia Resultad2 por Resultado2
		 
		 UPDATE #Resultado2 SET Id_Cliente_Ref = CL.id_cliente_ref FROM #Resultado2 R, Clientes CL WHERE R.Id_Cliente = CL.Id_Cliente
		 UPDATE #Resultado2 SET Razon_Social_Ref = CL.Razon_Social , Id_Cliente_Externo_Ref = CL.Id_Cliente_Externo FROM #Resultado2 R, Clientes CL WHERE R.Id_Cliente_Ref = CL.Id_Cliente
	     UPDATE #Resultado2 SET Razon_Social_Ref= '' WHERE ISNULL(id_cliente_ref,0)=0

		 Select c.id_cliente,i.id_producto,max(i.fecha_qa) Fecha_utl_Pago 
		       Into #UltPago2 
		       From cbtes c, cbtes_items i, #Resultado2 R
			   Where i.id_trans = c.id_trans and c.id_estado_cbte in (2,4)
			         and i.Id_Cliente = R.Id_Cliente
			         and i.id_producto = R.id_Producto
			   Group by c.id_cliente,i.id_producto



         UPDATE #Resultado2 SET Fecha_utl_Pago = U.Fecha_utl_Pago 
		 From #Resultado2 R, #UltPago2 u
		 WHERE 	u.Id_Cliente = R.Id_Cliente  and u.id_producto = R.id_Producto

		 SELECT * FROM #Resultado2  ORDER BY Razon_Social_Ref,Razon_Social,descripcion_detallada,mes
        END	   



PRINT 'F'

/*

EXEC [CP_Productos_DEUDA]	   -1  /*  @pUsuario    INT*/
							   ,1  /* @pFlag_Excluye_Pagos_A_Cuenta TINYINT	*/
							   ,90 /* @pEquate  SMALLINT */
							   ,400     /* @pEquateClientes SMALLINT  */
							   , '20220802'    /*@FECHA DATETIME*/

							    

*/
